package com.javacodegeeks.core.constructor;

public class Employee extends Person {
	private String job;

	public Employee() { 
		super();	// executes constructor  Person(), line 7 in Person.java
		this.job = "Unknown";
	}

	public Employee(String Name) {
		super(Name);	// executes constructor Person(String Name), line 13 in Person.java
		this.job = "Unknown";
	}

	public Employee(String Name, int Age, String Job) {
		super(Name, Age);	// executes constructor Person(String Name), line 19 in Person.java
		this.job = Job;
	}

	private String getJob() {
		return job;
	}

	public static void main(String args[]) {
		// We create three different objects, one with each constructor provided above.
		Employee employee1 = new Employee();
		Employee employee2 = new Employee("Tom");
		Employee employee3 = new Employee("George", 40, "Teacher");

		System.out.println("employee1: " + employee1.getName() + " is "
				+ employee1.getAge() + " years old " + employee1.getJob());
		System.out.println("employee2: " + employee2.getName() + " is "
				+ employee2.getAge() + " years old " + employee2.getJob());
		System.out.println("employee3: " + employee3.getName() + " is "
				+ employee3.getAge() + " years old " + employee3.getJob());

	}
}
