# Login to MySQL
mysql -u root -p

# Create new empty database
create database test;

# Show all databases
show databases;

# Switch to test database
use test;

# Create a test table
CREATE TABLE articles (
    id INT AUTO_INCREMENT,
    title VARCHAR(64) NOT NULL,
    posted_by VARCHAR(64) NOT NULL,
    posted_date DATE,
    active BIT(1) NOT NULL,
    last_update_date DATETIME,
    rating_percentage DOUBLE,
    views BIGINT,
    no_of_comments SMALLINT,
    category ENUM('JAVA', 'QUARTZ'),
    body TEXT,
    metadata JSON,
    PRIMARY KEY (id)
);

# Show articles table structure
describe articles;

# Insert data into articles table
insert into articles(title, posted_by, posted_date, active, last_update_date, rating_percentage, views, no_of_comments, category, body, metadata) values 
('Java Microservices', 'bob', '2019-04-01', 1, '2019-03-29 05:10:23', 85.23, 453, 5, 'JAVA', 'blah', '{"total_author_posts": 15, "tags": ["Java", "Microservices"]}'),
('Quartz Best Practices', 'tom', '2018-11-05', 1, '2018-11-04 15:43:00', 76.3, 7834, 28, 'QUARTZ', 'blah', '{"total_author_posts": 4, "tags": ["Quartz"]}'),
('Java HashMap', 'tom', '2015-04-24', 0, '2015-04-20', 34, 6543, 2, 'JAVA', 'blah', '{"tags": ["Java"]}');

# View numeric columns
select id, active+0, rating_percentage, views, no_of_comments from articles;

# View character columns
select id, title, posted_by, category, body from articles;

# Change the value of ENUM
update articles set category = 'Microservices' where id = 1;

# View date and time columns
select id, posted_date, last_update_date from articles;

# View JSON column
select id, title, metadata from articles;

# Update JSON to invalid one
update articles set metadata = '{"tags: Java"}' where id = 1;