
"""
__version__ = "$Revision: 1.38 $"
__date__ = "$Date: 2004/08/17 19:11:43 $"
"""

import wx
from wx.lib import dialogs
from font import Font, fontDescription


DialogResults = dialogs.DialogResults

#findDialog = dialogs.findDialog
# KEA 2004-08-17
# need input and result arg names to match
# so workaround the way it works in 2.5.2.7
def findDialog(parent=None, searchText='', wholeWordsOnly=False, caseSensitive=False):
    dlg = wx.Dialog(parent, -1, "Find", wx.DefaultPosition, (380, 120))

    wx.StaticText(dlg, -1, 'Find what:', (7, 10))
    wSearchText = wx.TextCtrl(dlg, -1, searchText, (80, 7), (195, -1))
    wSearchText.SetValue(searchText)
    wx.Button(dlg, wx.ID_OK, "Find Next", (285, 5), wx.DefaultSize).SetDefault()
    wx.Button(dlg, wx.ID_CANCEL, "Cancel", (285, 35), wx.DefaultSize)

    wWholeWord = wx.CheckBox(dlg, -1, 'Match whole word only',
                            (7, 35), wx.DefaultSize, wx.NO_BORDER)

    if wholeWordsOnly:
        wWholeWord.SetValue(1)

    wCase = wx.CheckBox(dlg, -1, 'Match case', (7, 55), wx.DefaultSize, wx.NO_BORDER)

    if caseSensitive:
        wCase.SetValue(1)

    wSearchText.SetSelection(0, len(wSearchText.GetValue()))
    wSearchText.SetFocus()

    result = DialogResults(dlg.ShowModal())
    result.searchText = wSearchText.GetValue()
    result.wholeWordsOnly = wWholeWord.GetValue()
    result.caseSensitive = wCase.GetValue()
    dlg.Destroy()
    return result


colorDialog = dialogs.colorDialog

# KEA 2004-08-14
# due to a typo of mine in wx.lib.fontDialog
# I have to include the full version of the function here
def wxFontDialog(parent=None, fontData=None, font=None):
    if fontData is None:
        fontData = wx.FontData()
        fontData.SetColour(wx.BLACK)
        fontData.SetInitialFont(wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT))

    if font is not None:
        fontData.SetInitialFont(font)

    dialog = wx.FontDialog(parent, fontData)
    result = DialogResults(dialog.ShowModal())

    if result.accepted:
        fontData = dialog.GetFontData()
        result.fontData = fontData
        result.color = fontData.GetColour().Get()
        result.colour = result.color
        result.font = fontData.GetChosenFont()
    else:
        result.color = None
        result.colour = None
        result.font = None

    dialog.Destroy()
    return result

def fontDialog(parent, aFont=None):
    if aFont is not None:
        aFont = aFont._getFont()
    result = wxFontDialog(parent, font=aFont)
    #result = dialogs.fontDialog(parent, font=aFont)
    if result.accepted:
        fontData = result.fontData
        result.color = result.fontData.GetColour().Get()
        fontWx = result.fontData.GetChosenFont()
        result.fontDescription = fontDescription(fontWx)
        fontWx = None
        result.font = Font(result.fontDescription)
    return result

# KEA 2004-08-15
# should we have a passwordEntryDialog and multilineEntryDialog
# for convenience rather than requiring the use of 
# wx.TE_PASSWORD or wx.TE_MULTILINE styles?
textEntryDialog = dialogs.textEntryDialog
messageDialog = dialogs.messageDialog
alertDialog = dialogs.alertDialog
scrolledMessageDialog = dialogs.scrolledMessageDialog
fileDialog = dialogs.fileDialog
openFileDialog = dialogs.openFileDialog
saveFileDialog = dialogs.saveFileDialog
directoryDialog = dialogs.directoryDialog

#singleChoiceDialog = dialogs.singleChoiceDialog
# KEA 2004-08-15
# another workaround for 2.5.2.7
def singleChoiceDialog(parent=None, message='', title='', lst=[], 
                       style=wx.OK | wx.CANCEL | wx.CENTRE):
    return dialogs.singleChoiceDialog(parent, message, title, list(lst), style | wx.DEFAULT_DIALOG_STYLE)

multipleChoiceDialog = dialogs.multipleChoiceDialog

