#!/usr/bin/python

"""
__version__ = "$Revision: 1.8 $"
__date__ = "$Date: 2004/05/05 16:53:46 $"
"""

from PythonCard import model
import wx
from wx import grid
import sys

class Minimal(model.Background):

    def on_initialize(self, event):
        self.log = sys.stdout
        self.moveTo = None

        wx.EVT_IDLE(self, self.OnIdle)
        
        mygrid = self.components.mygrid

        mygrid.CreateGrid(25, 25) #, wxGrid.wxGridSelectRows)
        ##mygrid.EnableEditing(False)

        # simple cell formatting
        mygrid.SetColSize(3, 200)
        mygrid.SetRowSize(4, 45)
        mygrid.SetCellValue(0, 0, "First cell")
        mygrid.SetCellValue(1, 1, "Another cell")
        mygrid.SetCellValue(2, 2, "Yet another cell")
        mygrid.SetCellValue(3, 3, "This cell is read-only")
        mygrid.SetCellFont(0, 0, wx.Font(12, wx.ROMAN, wx.ITALIC, wx.NORMAL))
        mygrid.SetCellTextColour(1, 1, wx.RED)
        mygrid.SetCellBackgroundColour(2, 2, wx.CYAN)
        mygrid.SetReadOnly(3, 3, True)

        mygrid.SetCellEditor(5, 0, grid.GridCellNumberEditor(1,1000))
        mygrid.SetCellValue(5, 0, "123")
        mygrid.SetCellEditor(6, 0, grid.GridCellFloatEditor())
        mygrid.SetCellValue(6, 0, "123.34")
        mygrid.SetCellEditor(7, 0, grid.GridCellNumberEditor())

        mygrid.SetCellValue(6, 3, "You can veto editing this cell")


        # attribute objects let you keep a set of formatting values
        # in one spot, and reuse them if needed
        attr = grid.GridCellAttr()
        attr.SetTextColour(wx.BLACK)
        attr.SetBackgroundColour(wx.RED)
        attr.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD))

        # you can set cell attributes for the whole row (or column)
        mygrid.SetRowAttr(5, attr)

        mygrid.SetColLabelValue(0, "Custom")
        mygrid.SetColLabelValue(1, "column")
        mygrid.SetColLabelValue(2, "labels")

        mygrid.SetColLabelAlignment(wx.ALIGN_LEFT, wx.ALIGN_BOTTOM)

        #mygrid.SetDefaultCellOverflow(False)
        #r = wx.GridCellAutoWrapStringRenderer()
        #mygrid.SetCellRenderer(9, 1, r)

        # overflow cells
        mygrid.SetCellValue( 9, 1, "This default cell will overflow into neighboring cells, but not if you turn overflow off.");
        mygrid.SetCellSize(11, 1, 3, 3);
        mygrid.SetCellAlignment(11, 1, wx.ALIGN_CENTRE, wx.ALIGN_CENTRE);
        mygrid.SetCellValue(11, 1, "This cell is set to span 3 rows and 3 columns");



        # test all the events
        grid.EVT_GRID_CELL_LEFT_CLICK(self, self.OnCellLeftClick)
        grid.EVT_GRID_CELL_RIGHT_CLICK(self, self.OnCellRightClick)
        grid.EVT_GRID_CELL_LEFT_DCLICK(self, self.OnCellLeftDClick)
        grid.EVT_GRID_CELL_RIGHT_DCLICK(self, self.OnCellRightDClick)

        grid.EVT_GRID_LABEL_LEFT_CLICK(self, self.OnLabelLeftClick)
        grid.EVT_GRID_LABEL_RIGHT_CLICK(self, self.OnLabelRightClick)
        grid.EVT_GRID_LABEL_LEFT_DCLICK(self, self.OnLabelLeftDClick)
        grid.EVT_GRID_LABEL_RIGHT_DCLICK(self, self.OnLabelRightDClick)

        grid.EVT_GRID_ROW_SIZE(self, self.OnRowSize)
        grid.EVT_GRID_COL_SIZE(self, self.OnColSize)

        grid.EVT_GRID_RANGE_SELECT(self, self.OnRangeSelect)
        grid.EVT_GRID_CELL_CHANGE(self, self.OnCellChange)
        grid.EVT_GRID_SELECT_CELL(self, self.OnSelectCell)

        grid.EVT_GRID_EDITOR_SHOWN(self, self.OnEditorShown)
        grid.EVT_GRID_EDITOR_HIDDEN(self, self.OnEditorHidden)
        grid.EVT_GRID_EDITOR_CREATED(self, self.OnEditorCreated)


        sizer1 = wx.BoxSizer(wx.VERTICAL)
        sizer1.Add(self.components.mygrid, 1, wx.EXPAND)
        
        sizer1.Fit(self)
        sizer1.SetSizeHints(self)
        self.panel.SetSizer(sizer1)
        self.panel.SetAutoLayout(1)
        self.panel.Layout()

    def OnCellLeftClick(self, event):
        self.log.write("OnCellLeftClick: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))
        event.skip()

    def OnCellRightClick(self, event):
        self.log.write("OnCellRightClick: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))
        event.skip()

    def OnCellLeftDClick(self, event):
        self.log.write("OnCellLeftDClick: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))
        event.skip()

    def OnCellRightDClick(self, event):
        self.log.write("OnCellRightDClick: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))
        event.skip()

    def OnLabelLeftClick(self, event):
        self.log.write("OnLabelLeftClick: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))
        event.skip()

    def OnLabelRightClick(self, event):
        self.log.write("OnLabelRightClick: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))
        event.skip()

    def OnLabelLeftDClick(self, event):
        self.log.write("OnLabelLeftDClick: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))
        event.skip()

    def OnLabelRightDClick(self, event):
        self.log.write("OnLabelRightDClick: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))
        event.skip()


    def OnRowSize(self, event):
        self.log.write("OnRowSize: row %d, %s\n" %
                       (event.GetRowOrCol(), event.GetPosition()))
        event.skip()

    def OnColSize(self, event):
        self.log.write("OnColSize: col %d, %s\n" %
                       (event.GetRowOrCol(), event.GetPosition()))
        event.skip()

    def OnRangeSelect(self, event):
        if event.Selecting():
            self.log.write("OnRangeSelect: top-left %s, bottom-right %s\n" %
                           (event.GetTopLeftCoords(), event.GetBottomRightCoords()))
        event.skip()


    def OnCellChange(self, event):
        self.log.write("OnCellChange: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))

        # Show how to stay in a cell that has bad data.  We can't just
        # call SetGridCursor here since we are nested inside one so it
        # won't have any effect.  Instead, set coordinants to move to in
        # idle time.
        value = self.components.mygrid.GetCellValue(event.GetRow(), event.GetCol())
        if value == 'no good':
            self.moveTo = event.GetRow(), event.GetCol()


    def OnIdle(self, event):
        if self.moveTo != None:
            self.components.mygrid.SetGridCursor(self.moveTo[0], self.moveTo[1])
            self.moveTo = None
        event.skip()


    def OnSelectCell(self, event):
        self.log.write("OnSelectCell: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))

        # Another way to stay in a cell that has a bad value...
        mygrid = self.components.mygrid
        row = mygrid.GetGridCursorRow()
        col = mygrid.GetGridCursorCol()
        if mygrid.IsCellEditControlEnabled():
            mygrid.HideCellEditControl()
            mygrid.DisableCellEditControl()
        value = mygrid.GetCellValue(row, col)
        if value == 'no good 2':
            return  # cancels the cell selection
        event.skip()


    def OnEditorShown(self, event):
        if event.GetRow() == 6 and event.GetCol() == 3 and \
           wx.MessageBox("Are you sure you wish to edit this cell?",
                        "Checking", wxYES_NO) == wxNO:
            event.Veto()
            return

        self.log.write("OnEditorShown: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))
        event.skip()


    def OnEditorHidden(self, event):
        if event.GetRow() == 6 and event.GetCol() == 3 and \
           wx.MessageBox("Are you sure you wish to  finish editing this cell?",
                        "Checking", wx.YES_NO) == wx.NO:
            event.Veto()
            return

        self.log.write("OnEditorHidden: (%d,%d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetPosition()))
        event.skip()


    def OnEditorCreated(self, event):
        self.log.write("OnEditorCreated: (%d, %d) %s\n" %
                       (event.GetRow(), event.GetCol(), event.GetControl()))


if __name__ == '__main__':
    app = model.Application(Minimal)
    app.MainLoop()
