
"""
__version__ = "$Revision: 1.13 $"
__date__ = "$Date: 2004/08/12 19:14:23 $"
"""

from PythonCard import dialog, model
import os

class BackgroundInfoDialog(model.CustomDialog):
    def __init__(self, aBg, rsrc):
        model.CustomDialog.__init__(self, aBg)
        
        self.parent = aBg
        
        # if some special setup is necessary, do it here
        self.components.fldName.text = rsrc.name
        self.components.fldTitle.text = rsrc.title
        self.components.fldPosition.text = str(rsrc.position)
        self.components.fldSize.text = str(rsrc.size)
        self.components.chkStatusBar.checked = rsrc.statusBar
        if rsrc.foregroundColor is not None:
            #self.components.fldForegroundColor.text = colorDescription(rsrc.foregroundColor)
            self.components.fldForegroundColor.text = str(rsrc.foregroundColor)
        if rsrc.backgroundColor is not None:
            #self.components.fldBackgroundColor.text = colorDescription(rsrc.backgroundColor)
            self.components.fldBackgroundColor.text = str(rsrc.backgroundColor)
        if rsrc.image is not None:
            self.components.fldImage.text = rsrc.image
        self.components.chkTiled.checked = rsrc.tiled
        self.components.chkVisible.checked = rsrc.visible
        self.components.chkResizeable.checked = (rsrc.style != [])
            
        if rsrc.icon is not None:
            self.components.fldIcon.text = rsrc.icon

    def on_btnForegroundColor_mouseClick(self, event):
        result = dialog.colorDialog(self)
        if result.accepted:
            self.components.fldForegroundColor.text = str(result.color)

    def on_btnBackgroundColor_mouseClick(self, event):
        result = dialog.colorDialog(self)
        if result.accepted:
            self.components.fldBackgroundColor.text = str(result.color)

    def on_btnFile_mouseClick(self, event):
        result = dialog.openFileDialog()
        if result.accepted:
            path = result.paths[0]
            filename = os.path.split(path)[-1]
            self.components.fldImage.text = filename

    def on_btnIconFile_mouseClick(self, event):
        wildcard = "Icon Files (*.ico)|*.ico|XPM Files (*.xpm)|*.xpm|All Files (*.*)|*.*"
        result = dialog.openFileDialog(wildcard=wildcard)
        if result.accepted:
            path = result.paths[0]
            filename = os.path.split(path)[-1]
            self.components.fldIcon.text = filename
        
